window.onload = function() {
    loadTasks();
};

function changeBackground() {
    var body = document.body;
    if (body.style.backgroundColor === "rgb(38, 38, 38)") {
        body.style.backgroundColor = "#ff93c9";
    } else {
        body.style.backgroundColor = "#262626";
    }
}

function addTask() {
    var taskInput = document.getElementById("taskInput");
    var taskText = taskInput.value.trim();
    if (taskText !== "") {
        var taskList = document.getElementById("taskList");
        var listItem = document.createElement("li");
        listItem.textContent = taskText;
        var deleteButton = document.createElement("button");
        deleteButton.className = "delete-btn";
        deleteButton.onclick = function() {
            taskList.removeChild(listItem);
            saveTasks();
        };
        listItem.appendChild(deleteButton);
        taskList.appendChild(listItem);
        saveTasks();
        taskInput.value = "";
    } else{
        alert("Please enter a task before adding.")
    }
}

function saveTasks() {
    var taskList = document.getElementById("taskList");
    var tasks = [];
    for (var i = 0; i < taskList.children.length; i++) {
        tasks.push(taskList.children[i].textContent);
    }
    localStorage.setItem("tasks", JSON.stringify(tasks));
}

function loadTasks() {
    var taskList = document.getElementById("taskList");
    var tasks = JSON.parse(localStorage.getItem("tasks")) || [];
    taskList.innerHTML = "";
    for (var i = 0; i < tasks.length; i++) {
        var listItem = document.createElement("li");
        listItem.textContent = tasks[i];
        var deleteButton = document.createElement("button");
        deleteButton.textContent = "";
        deleteButton.className = "delete-btn";
        deleteButton.onclick = function() {
            taskList.removeChild(listItem);
            saveTasks();
        };
        listItem.appendChild(deleteButton);
        taskList.appendChild(listItem);
    }
}